
#ifndef SST_TST_ATP_INITTERMINATE_H
#define SST_TST_ATP_INITTERMINATE_H
#if TST_USE_INIT_TERMINATE_MODULE
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_InitTerminate.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/
    /*****************************************************************************
    * Function Name:                                                           
    *  SST_TST_ATP_InitTerminate         
    * 
    * Inputs:
    *  None
    *
    * Outputs:
    *  DxError_t - Function error return                                        
    *
    * Description:                                                                 
    *   Verify that init and terminate commands work
    *  
    * Algorithm:       
    *    1.  Terminate the SST operation by calling: SST_Terminate.
    *    2.  Initialize the SST again by calling: SST_Init.
    *    3.  Create a new session by calling: SST_SessionCreate.
    *    4.  Open a transaction by calling: SST_TransactionStart.
    *    5.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
    *    6.  Close the transaction by calling: SST_TransactionEnd.
    *    7.  Delete the session by calling: SST_SessionDelete.
    *    8.  Terminate the SST operation by calling: SST_Terminate.
    *    9.  Initialize the SST again by calling: SST_Init.
    *    10.  Create a new session by calling: SST_SessionCreate.
    *    11.  Open the password authenticator by calling: SST_AuthenticationOpen.
    *    12.  Open a transaction by calling: SST_TransactionStart.
    *    13.  Insert a new data object by calling: SST_InsertData.
    *    14.  Close the transaction by calling: SST_TransactionEnd.
    *    15.  Delete the session by calling: SST_SessionDelete.
    *    16.  Terminate the SST operation by calling: SST_Terminate.
    *    17.  Initialize the SST again by calling: SST_Init.
    *    18.  Create a new session by calling: SST_SessionCreate.
    *    19.  Open the password authenticator by calling: SST_AuthenticationOpen.
    *    20.  Read and compare the inserted data by calling: SST_ReadData.
    *    21.  Delete the session by calling: SST_SessionDelete.
    *    22.  Terminate the SST operation by calling: SST_Terminate.
    *    23.  Initialize the SST again by calling: SST_Init.
    *    24.  Create a new session by calling: SST_SessionCreate.
    *    25.  Open the password authenticator by calling: SST_AuthenticationOpen.
    *    26.  Open a transaction by calling: SST_TransactionStart.
    *    27.  Modify the data from selected location by calling: SST_ModifyData.
    *    28.  Close the transaction by calling: SST_TransactionEnd.
    *    29.  Delete the session by calling: SST_SessionDelete.
    *    30.  Terminate the SST operation by calling: SST_Terminate.
    *    31.  Initialize the SST again by calling: SST_Init.
    *    32.  Create a new session by calling: SST_SessionCreate.
    *    33.  Open the password authenticator by calling: SST_AuthenticationOpen.
    *    34.  Read and compare the inserted data by calling: SST_ReadData.
    *    35.  Get Data Size and compare by calling: SST_DataSizeGet.
    *    36.  Delete the session by calling: SST_SessionDelete.
    *    37.  Terminate the SST operation by calling: SST_Terminate.
    *    38.  Initialize the SST again by calling: SST_Init.
    *    39.  Create a new session by calling: SST_SessionCreate.
    *    40.  Open the password authenticator by calling: SST_AuthenticationOpen.
    *    41.  Open a transaction by calling: SST_TransactionStart.
    *    42.  Delete the data object by calling: SST_DataDelete.
    *    43.  Delete the authenticator by calling: SST_AuthenticatorDelete.
    *    44.  Close the transaction by calling: SST_TransactionEnd.
    *    45.  Delete the session by calling: SST_SessionDelete.
    *    46.  Terminate the SST operation by calling: SST_Terminate.
    *    47.  Initialize the SST again by calling: SST_Init.
    *                          
    ********************************************************************************/  
DxError_t SST_TST_ATP_InitTerminate ( void );

#ifdef __cplusplus
}
#endif

#endif

#endif


